<?php $__env->startSection('template_title'); ?>
    <?php echo e(trans('installer_messages.environment.wizard.templateTitle')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <i class="fa fa-magic fa-fw" aria-hidden="true"></i>
    Setup Admin User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="tabs tabs-full setup_final_page">

        <h4>Information needed <small>(Login credentials)</small></h4>
        <p class="mt-2 max-w-3xl mx-auto">
            Please provide the following information. Do not worry, you can always change these settings later. The email and password you input here will be your admin login credentials.
        </p>

        <form method="post" action="<?php echo e(route('LaravelInstaller::saveAdminSetup')); ?>" class="tabs-wrap">
            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">

            <div class="form-group <?php echo e($errors->has('first_name') ? ' has-error ' : ''); ?>">
                <label for="app_pce">
                    <?php echo e('First Name'); ?>

                </label>
                <input type="text" name="first_name" id="first_name" value="" placeholder="<?php echo e('your first name here'); ?>" />
                <?php if($errors->has('first_name')): ?>
                    <span class="error-block">
                            <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                            <?php echo e('The first name is required.'); ?>

                        </span>
                <?php endif; ?>
            </div>

            <div class="form-group <?php echo e($errors->has('last_name') ? ' has-error ' : ''); ?>">
                <label for="app_pce">
                    <?php echo e('Last Name'); ?>

                </label>
                <input type="text" name="last_name" id="last_name" value="" placeholder="<?php echo e('your last name here'); ?>" />
                <?php if($errors->has('last_name')): ?>
                    <span class="error-block">
                            <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                            <?php echo e('The last name is required.'); ?>

                        </span>
                <?php endif; ?>
            </div>

            <div class="form-group <?php echo e($errors->has('email') ? ' has-error ' : ''); ?>">
                <label for="app_pce">
                    <?php echo e('Email'); ?>

                </label>
                <input type="text" name="email" id="email" value="" placeholder="<?php echo e('your email address to login'); ?>" />
                <?php if($errors->has('email')): ?>
                    <span class="error-block">
                            <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                            <?php echo e('The email is required.'); ?>

                        </span>
                <?php endif; ?>
            </div>

            <div class="form-group <?php echo e($errors->has('password') ? ' has-error ' : ''); ?>">
                <label for="app_pce">
                    <?php echo e('Password'); ?>

                </label>
                <input type="text" name="password" id="password" value="" placeholder="<?php echo e('a new password to login'); ?>" />
                <?php if($errors->has('password')): ?>
                    <span class="error-block">
                            <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                            <?php echo e('The password is required.'); ?>

                        </span>
                <?php endif; ?>
            </div>

           <p class="alert font-semibold mt-4">
               Please make sure to securely store your email and password. If you forget these credentials, you won't be able to access the admin dashboard.
           </p>

            <div class="buttons">
                <button class="button">
                    <?php echo e(__('Complete Setup')); ?>

                    <i class="fa fa-angle-right fa-fw" aria-hidden="true"></i>
                </button>
            </div>
        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        function checkEnvironment(val) {
            var element=document.getElementById('environment_text_input');
            if(val=='other') {
                element.style.display='block';
            } else {
                element.style.display='none';
            }
        }
        function showDatabaseSettings() {
            document.getElementById('tab2').checked = true;
        }
        function showApplicationSettings() {
            document.getElementById('tab3').checked = true;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.installer.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/myasidoc/public_html/connectivity.support.myasido.com/resources/views/vendor/installer/admin-setup.blade.php ENDPATH**/ ?>